function [dof,logL]=EstimateStaticTCopula(data,optimizer)
% Estimate the degree of freedom parameter of the T Copula
% INPUTS
% data:             A matrix of U(0,1) or iid margins
% optimizer:        String with values 'fmincon' or 'fminunc'
% OUTPUTS
% dof:              The value of the parameter
% logL:             Log likelihood at the optimum
% ------------------------------------------------------------------------
% Author: Manthos Vogiatzoglou, UoM, 2008 - 2009
% contact at: vogia@yahoo.com

if nargin==1
    optimizer='fmincon';
end
options = optimset('Display','iter','MaxFunEvals',10000,'TolCon',10^-12,'TolFun',10^-5,'TolX',10^-4);
if strcmp(optimizer,'fminunc')
    initialparams=2;
    [theta, likhood]= fminunc('StaticTCopulaLL',initialparams,options,data,optimizer);
    dof=2+exp(theta);
    logL=-likhood;
elseif strcmp(optimizer,'fmincon')
    initialparams=13;
    lower=2.01;
    upper=300;
    [theta, likhood]= fmincon('StaticTCopulaLL',initialparams,[],[],[],[],lower,upper,[],options,data,optimizer);
    dof=theta;
    logL=-likhood;
end
